<?php

// Get the slug from the URL, if it's not set, return an error or redirect
$slug = isset($_GET['slug']) ? $_GET['slug'] : null;
$pageNumber = isset($_GET['pageNumber']) ? (int)$_GET['pageNumber'] : 1;
$blog = null;
$blogs = null;
$recentBlog=[];

// Function to initialize cURL and make a request
function fetchContent($url, $headers) {
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => $headers,
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    return $response;
}

$headers = array(
    'X-blog-key: qp643cd29t',
    'Cookie: accessToken=eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6MSwiaWF0IjoxNzI5NTg2MTQwLCJleHAiOjE3MzA0NTAxNDB9.hdIkzgAWWjCs8Eoxhh00VSzYLysXtNwire1Ns8h6wsw'
);

if ($slug) {
    $url = "https://cms.realtyassistant.in/app/v1/public/blog/{$slug}";
    $response = fetchContent($url, $headers);

    $blogData = json_decode($response, true);
    if ($blogData && $blogData['status'] && isset($blogData['data'])) {
        $blog = $blogData['data'];
        $tags = $blogData['data']['BlogTagForBlog'];
        $category = $blogData['data']['BlogCategoryForBlog'];
        
       
       
       
    } else {
        echo "No blog found or invalid response.";
    }
} else {
    echo "No slug provided.";
}

$urlList = "https://cms.realtyassistant.in/app/v1/public/blog/list?title=&orderby=desc&take=4&pageNumber=1&type=";
$responseList = fetchContent($urlList, $headers);

$responseArray = json_decode($responseList, true);
if ($responseArray && isset($responseArray['data']['data'])) {
    $recentBlog = $responseArray['data']['data'];
} else {
    echo "Failed to decode JSON response.";
}

function truncateText($text, $wordLimit = 10) {
    $words = explode(' ', $text);
    return count($words) > $wordLimit ? implode(' ', array_slice($words, 0, $wordLimit)) . '...' : $text;
}


// Default form data
$formArr = [
      'project_id' => '353',
                    'referral_url'    => $_SERVER['HTTP_REFERER'],
                   'url_params'     =>  http_build_query($_GET),
   'website_url' => 'https://mallofnoidasector98.com'
];

if (!empty($_REQUEST['source'])) {
    $formArr['campaign_source'] = $_REQUEST['source'];
}

// Submit form data via cURL
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL            => 'https://leads.realtyassistant.in/api/getForm',
    CURLOPT_POST           => 1,
    CURLOPT_POSTFIELDS     => http_build_query($formArr),
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER     => ['Content-Type: application/x-www-form-urlencoded']
]);

$responseData = json_decode(curl_exec($ch), true);
curl_close($ch);

$check = !($responseData && $responseData['status']);

// Prepare form content
if ($check) {
     $common_form = '<form method="POST" action="send.php" class="common_form_main class_name_for_selenium">' .
      '<input type="hidden" name="submit_form" value="1">' .
      '<input type="hidden" name="project_id" value="353">' .
      '<input type="hidden" name="referral_url" value="">' .
      '<input type="hidden" name="tracker_id" value="1714998897">' .
      '<input type="hidden" name="website_url" value="https://mallofnoidasector98.com/">' .
      '<div class="form-group">' .
      '<input type="text" name="name" class="form-control name_for_selenium" placeholder="Your Name*" required>' .
      '</div>' .
      '<div class="form-group">' .
      '<input class="required quantity form-control phonevaidation phone_for_selenium" name="phone" type="tel" placeholder="Mobile No.*" minlength="10" maxlength="10" style="width:100%; float:left;" required>' .
      '</div>' .
      '<div class="form-group">' .
      '<input class="form-control validateEmail email_for_selenium" name="email" type="email" placeholder="Email Id" style="width:100%; float:left;">' .
      '</div>' .
      '<div class="form-group" style="text-align: center;">' .
      '<button type="submit" class="btn btn-primary btncss submitContactBtn submit_for_selenium" name="submit_form">Enquiry Now </button>' .
      '</div>' .
      '</form>';
} else {
    $common_form   = $responseData['data']['formInput'];
    $common_header = $responseData['data']['formHeader'];
    $common_body   = $responseData['data']['formBody'];
    $common_footer = $responseData['data']['footerScript'];
}

?>

<!DOCTYPE html><html lang="zxx"><head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>mall of noida sector98 </title>
<meta name="description" content="">
<meta name="keywords" content="">
  <link rel="stylesheet" href="/neww/css/bootstrap.min.css">
  <link rel="stylesheet" href="/neww/css/boxicons.min.css">
  <link rel="stylesheet" href="/neww/css/magnific-popup.css">
  <link rel="stylesheet" href="/neww/css/style.css">
  <link rel="stylesheet" href="/neww/css/responsive.css">
  <link rel="shortcut icon" href="/neww/images/logo-black.png" type="image/x-icon">
  <style>
  @media only screen and (max-width: 1024px) {
    @media only screen and (max-width: 767px) {
        .mean-menu {
            background: #caa172;
            display: block;
            height: 100vh;
            left: -100%;
            opacity: 0;
            position: fixed;
            text-align: center;
            top: 0;
            transition: .4sease-in;
            width: 300px;
            z-index: 99999;
            top: 58px !important;
        }
    }
}
    button {
    /* width: 100%; */
    /* height: 80px; */
    position: relative;
    background: rgba(255, 255, 255, .27);
    text-transform: uppercase;
    color: white;
    font-weight: 700;
    letter-spacing: 1px;
    border: none;
    font-size: 15px;
    outline: none;
    cursor: pointer;
    border-radius: 0px !important;
}

  @media only screen and (max-width:1024px) {
         @media only screen and (max-width:1024px) {
  .navbar-expand-md .navbar-nav {
        flex-direction: column;
       
    }
        body.mobile-open .mean-menu{
             align-items: start;
        }
        .navbar-expand-md .mean-menu {
        justify-content: center;
    }
    .navbar-expand-md {
        flex-wrap: nowrap;
        justify-content: space-between;
    }
	.sticky-patch {
		position: absolute;
		z-index: 9999;
		width: 22%;
		left: 68%;
		top: 81%;
	}
	.section-title p {
		font-size: 16px;
		/* text-align: justify; */
	}
	.amenities-img {
		width: 55%;
	}

	li.nav-item.has_submenu.submenu-open {
		padding-bottom: 0;
	}
	.main-nav nav .navbar-nav .nav-item .dropdown-menu {
		position: relative;
    opacity: 100;
    visibility: visible;
    transform: none;
    background-color: inherit;
    border: none;
    padding: 0;
	}
	.main-nav nav .navbar-nav .nav-item .dropdown-menu li {
		border: none;
	}
	
	.main-nav nav .navbar-nav .nav-item .dropdown-menu li a {
		border: none;
	}

	.main-nav nav .navbar-nav .nav-item .dropdown-menu li a{
		font-size: 16px;
    margin-left: 0;
    padding-left: 10px;
    padding-right: 10px;
	}
	.top_footer{
		padding-bottom: 0;
	}
	.footer-widget .footer-logo img {
		max-width: 160px;
		margin-bottom: 0;
	}
	.footer-area .address {
		padding-bottom: 0px;
	}
	.section-title span {
		font-size: 12px
	}

	.section-title h2 {
		font-size: 26px;
		text-align: center;
		font-weight: 600;
	}

	.mobile-nav .logo .logo-two {
		display: none
	}

	.nav-btn-area {
		display: none
	}

	.banner-area {
		background-color: #fef9eb
	}

	.banner-content {
		margin-left: auto;
		margin-right: auto;
		padding-top: 130px
	}

	.banner-content h1 {
		font-size: 35px;
		margin-bottom: 15px
	}

	.banner-content p {
		font-size: 16px;
		margin-bottom: 20px
	}

	.banner-content .banner-btn .buy-btn {
		padding: 8px 30px
	}

	.banner-content .banner-btn .rent-btn {
		padding: 8px 26px
	}


	.banner-content {
		margin-left: auto;
		margin-right: auto;
		padding-top: 130px;
		padding-bottom: 75px
	}

	.banner-content h1 {
		font-size: 35px;
		margin-bottom: 15px
	}

	.banner-content p {
		font-size: 16px;
		margin-bottom: 20px
	}

	.banner-content .banner-btn .buy-btn {
		padding: 8px 30px
	}

	.banner-content .banner-btn .rent-btn {
		padding: 8px 26px
	}

	.inner-banner .inner-title {
		padding-top: 200px;
		padding-bottom: 160px;
		text-align: center
	}

	.inner-banner .inner-title h3 {
		font-size: 38px
	}

	.inner-banner .inner-title ul li {
		font-size: 16px
	}

	.inner-banner .inner-title ul li::before {
		top: 10px
	}

	.about-content {
		margin-left: 0;
		margin-top: 30px;
	}

	.about-content .about-btn {
		margin-top: 5px
	}

	.property-features-img .shape {
		display: none
	}

	.highlight-content {
		margin-left: 0
	}


	.highlight-content h2 {
		font-size: 26px;
		text-align: left;
	}

	.highlight-content .list-content {
		margin-top: 0px;
		margin-bottom: 25px
	}

	.highlight-content .list-content li {
		font-size: 15px;
		margin-bottom: 0;
	}

	.highlight-content .list-content li b {
		font-size: 17px
	}

	.innovation-img {
		margin-top: 0;
		margin-bottom: 30px;
		margin-left: auto;
		margin-right: auto
	}

	.innovation-shape {
		display: none
	}

	.testimonials-item {
		padding: 30px 20px
	}

	.footer-widget h3 {
		margin-top: 0;
		font-size: 22px;
		color: #000;
		margin-bottom: 20px
	}

	.slider-content {
		max-width: 75%;
	}

	.banner-content .banner-btn-two .rent-btn {
		margin-left: 0;
		margin-top: 20px;
	}



	.about-section {
		padding-bottom: 50px;
	}

	.mobile_form {
		display: block;
		margin-top: 40px;
	}

	.home_slider .form-box.col-lg-5 {
		display: none;
	}

	.mobile_form .form-box.col-lg-5 {
		position: relative;
		left: 0;
		padding: 20px 15px;
		width: 89%;
		bottom: 0;
		outline-offset: initial;
		margin: 0 auto;
	}

	.slider-content {
		max-width: 100%;
		left: 0;
	}

	.banner-content ul li {
		letter-spacing: 1px;
	}

	.banner-content .ivr-number {
		font-size: 20px;
		margin-bottom: 24px;
		padding: 10px;
	}



	button.carousel-control-next {
		left: 14%;
	}

	.banner-content p {
		margin-bottom: 10px;
	}

	.about-section.margin_tb {
		padding: 50px 0;
	}

	.mean-container .mean-bar {
		background: #aa9277;
	}

	.mobile-nav .logo img {
		max-width: 150px;
		width: 100%;

	}

	.mobile-nav {
		display: flex;
		background: #aa9277;
		justify-content: space-between;
	}

	.mobile-trigger {
		cursor: pointer;
		display: inline-block !important;
		height: auto;
		line-height: normal;
		padding: 0;
		position: relative;
		right: 15px;
		/* top: 5px; */
		width: auto;
		z-index: 99999;

	}

	.mobile-trigger i,
	.mobile-trigger i:after,
	.mobile-trigger i:before {
		background-color: #283b5c;
		border-radius: 1px;
		display: inline-block;
		height: 3px;
		width: 24px;
		position: relative;
		top: 0;
	}

	.mobile-trigger i,
	.mobile-trigger i:after,
	.mobile-trigger i:before {
		background-color: #000;
		-webkit-border-radius: 1px;
		-moz-border-radius: 1px;
		border-radius: 1px;
		display: inline-block;
		height: 3px;
		width: 24px;
	}

	.mobile-trigger i:after,
	.mobile-trigger i:before {
		content: "";
		position: absolute;

	}

	.mobile-trigger i:before {
		top: -6px;
	}

	.mobile-trigger i:after {
		top: 6px;
	}



	.main-nav {
		background: #fef9eb;
	}

	.slider-content {
		left: 0;
	}

	.mean-menu {
		background: #caa172;
		display: block;
		height: 100vh;
		left: -100%;
		opacity: 0;
		position: fixed;
		text-align: center;
		top: 0;
		transition: .4s ease-in;
		width: 300px;
		z-index: 99999;
		top: 8%;
	}

	body.mobile-open .mean-menu {
		left: 0;
		opacity: 1;
	}

	.main-nav nav .navbar-nav .nav-item {
		padding: 10px 15px;
		border-top: 1px solid rgba(255, 255, 255, .075);
		list-style: none;
		margin-bottom: 0;
		position: relative;
		text-align: left;
	}

	.mobile-open .mobile-trigger i:before {
		background-color: #000;
		bottom: 0;
		top: 0;
		transform: rotate(-45deg);
		transition: bottom .3s cubic-bezier(.23, 1, .32, 1), transform .3s cubic-bezier(.23, 1, .32, 1) .3s;
	}

	.mobile-open .mobile-trigger i:after {
		background-color: #000;
		top: 0;
		transform: rotate(45deg);
		transition: top .3s cubic-bezier(.23, 1, .32, 1), transform .3s cubic-bezier(.23, 1, .32, 1) .3s;
	}

	.mobile-open .mobile-trigger i {
		background-color: transparent;
	}

	.mobile-open .mobile_overlay {
		background-color: #000000a1;
		opacity: 1;
		pointer-events: all;
	}

	.mobile_overlay {
		background-color: rgba(0, 0, 0, .5);
		height: 100%;
		left: 0;
		opacity: 0;
		pointer-events: none;
		position: absolute;
		top: 0;
		transition: .5s ease-in-out;
		width: 100%;
		z-index: 9999;
	}

	.navbar {
		padding: 0;
	}

	.main-nav nav .navbar-nav .nav-item a {
		color: #000;
	}

	.slider-content {
		top: 14%;
	}

	.carousel-control-prev {
		left: 2%;
	}

	button.carousel-control-next {
		left: 15%;
	}

	.form-box.col-lg-5 {
		right: 0%;
	}

	.about-section {
		padding: 30px 0;
	}


	.section-title span {
		font-size: 20px;
	}

	.price_list .col-md-4 {
		margin-bottom: 30px;
	}

	.price_list .col-md-4 {
		margin-bottom: 30px;
	}

	.floor_plan .col-lg-4 {
		margin-bottom: 30px;
	}

	.price_list .col-md-4 {
		margin-bottom: 30px;
	}

	.floor_plan .col-lg-4 {
		margin-bottom: 40px;
	}

	.pricingTable10 .price-value {
		font-size: 30px;
	}

	a.main_button.btn {
		padding: 8px 30px;

	}

	.pricingTable10 .pricing-content ul li {
		font-size: 18px;
		font-weight: 700;
		color: #000;
		padding: 10px 0;
		border-bottom: 1px solid #d9d9d8;
	}

	.amenities-item {
		padding: 15px 30px 15px;
		margin-bottom: 15px;
	}

	.amenities-item h3 {
		font-size: 14px;
	}

	.home_page .contact-area .contact-form .form-box.col-lg-5 {
		width: 100%;
		padding: 35px 20px;
	}

	.home_page .contact-area .contact-form {
		max-width: 100%;
		padding: 0;
	}

	.pricingTable10 .pricing-content {
		padding-top: 35px;
		padding-bottom: 35px;
	}

	.home_page .contact-area .about_developer {
		padding-right: 0px;
    padding-bottom: 20px;
	}

	.carousel-item img {
		min-height: 600px;
		object-fit: cover;
	}

	.banner-content {
		margin: 0;
	}

	.form_btn .submit_button {
		width: auto;
	}

	.mean-menu {
		top: 53px;
	}
	/* .main_page .mean-menu {
		top:60px;
	} */
	.navbar-brand img {
		filter: none;
	}

	.fixed-header .main-nav {
		background: #fef9eb;
	}

	.modal .modal-body {
		flex-direction: column;
	}

	.modal .left_col,
	.modal .right_col {
		max-width: 100%;
	}

	.mobile-section {
		display: flex;
		z-index: 99;
	}

	.slider-content {
		padding-right: 20px;
	}

	.banner-content p.mini {
		padding: 5px 0;
		font-size: 16px;
	}
	.main_page .banner-content p.mini {
		letter-spacing: 1.5px;
	}
	.banner-content h1 {
		font-size: 31px;
		margin-bottom: -1px;
	}
	.main_page .banner-content h1 {
		font-size: 36px;
	}
	.banner-content h3 {
		font-size: 20px;
		letter-spacing: normal;
	}

	.banner-content ul li {
		padding-bottom: 0px;
		font-size: 17px;
	}

	.banner-content .price {
		font-size: 21px;
	}

	.banner-content h3.ivr-number {
		margin-top: 0;
		margin-bottom: 0;
		padding-left: 0;
	}

	.banner-content h3.ivr-number a {
		font-size: 20px;

	}

	.banner-content h3.ivr-number img {
		width: 30px;
	}

	.carousel-control-prev {
		left: 10%;
		bottom: 3%;
	}

	button.carousel-control-next {
		bottom: 3%;
		left: 23%;
	}

	p.side-location {
		top: 55%;
		left: -9%;
		font-size: 16px;
	}

	p.side-location::before,
	p.side-location::after {
		top: 14px;
	}

	.carousel-control-next-icon,
	.carousel-control-prev-icon {
		height: 31px;
		width: 31px;
	}

	button.carousel-control-next {
		left: auto;
		bottom: 3%;
		right: 0;
	}

	.carousel-control-prev {
		left: auto;
		bottom: 3%;
		right: 11%;
	}

	.banner-content {
		padding: 0;
	}

	.highlight .row.align-items-center {
		flex-direction: column-reverse;
	}

	.ptb-70 {
		padding-top: 30px;
		padding-bottom: 30px;
	}

	.floor_plan .section-title.text-center {
		margin-bottom: 30px;
	}

	.home_page .contact-area .section-title.text-center {
		margin-bottom: 30px;
	}

	.footer-area .address {
		flex-direction: column;
	}

	.footer-area .address .col-lg-4 {
		padding-bottom: 15px;
	}

	.footer-area {
		text-align: center;
	}

	.copy-right-area {
		padding-bottom: 80px;
	}

	p.side-location {
		left: auto;
		right: -38px;
		transform: rotate(90deg);
		top: 44%;
	}
	.project_section button.slick-next.slick-arrow {
		right: 38%;
		top: auto;
		bottom: -7%;
	}

	.project_section button.slick-prev.slick-arrow {
		right: 50%;
		top: auto;
		bottom: -7%;
	}

	button.slick-prev.slick-arrow:before,
	button.slick-next.slick-arrow:before {
		font-size: 20px;
		width: 35px;
		height: 35px;
	}
	.project_section .inner_content .col-lg-4 {
		padding: 0;
	}
	.testimonials-area button.slick-next.slick-arrow {
		left: 54%;
	}
.testimonials-area button.slick-prev.slick-arrow {
    left: 40%;
  
}
	.testimonials-area{
		margin-bottom: 0;
	}
	.contact-area {
		background-position: center;
	}
	.main_page .copy-right-area.main_footer {
		padding-bottom: 45px;
	}
	.main_page .slider-content {
		top: 30%;
	}


	.main_page .banner-content p{
		max-width: 100%;
	}
	.main_page .slider-content {
		padding-right: 12px;
	}

	.main-nav nav .navbar-nav .nav-item a i {
		position: absolute;
		font-size: 18px;
		right: 19px;
		top: 25px;
	}
	.carousel-item img {
		height: auto;
	}
	.modal .left_col, .modal .right_col {
		padding: 15px;
	}
	.modal .left_col img {
	
		max-width: 170px;
	}
	.modal .modal-body .main_button {
		margin-top: 0;
		font-size: 17px;
		padding: 10px 30px;
	}

	p.about-developer {
		font-size: 16px;
		text-align: justify;
	}
	
	.home_page .contact-area .about_developer h4 {
		font-size: 25px;
		
	}
	.project_section .inner_content {
		padding-top: 30px;
	}
	.about-content .section-title h2 {
		text-align: left;
	}

	.about-content p {
		text-align: justify;
	}
	.m-view {
        display: block;
    }
	.banner-content p {
        margin-bottom: 20px;
		font-size: 16px;
    }
	.banner-content h3 {
        font-size: 18px;
        letter-spacing: normal;
    }
	.banner-content ul li {
        padding-bottom: 0px;
        font-size: 15px;
        display: flex;
        color: white;
        align-items: flex-start;
    }
	.side-location.d-view{
		display: none;
	  }
	  .banner-content .price {
        padding: 10px 10px;
		font-size: 16px;
    }
	.banner-content h3.ivr-number a {
        font-size: 16px;
        padding: 10px 10px;
    }
	.inner .form-row {
		margin-bottom: 8px;
	}
	.modal .modal-body .form-group {
		margin-bottom: 10px;
		position: relative;
	}
	.about-content {
		margin-bottom: 0px;
		margin-left: 0px;
	}
}
  .contact-area {
    background-image: url(../images/bg-map-footer.png);
    height: 584px;
}
  .main-nav nav .navbar-nav .nav-item a {
    text-transform: capitalize;
    color: #fff!important;
    font-weight: 600;
    margin-left: 16px;
    margin-right: 16px;
    font-size: 18px;
    padding: 0;
}
.nav-btn-area .nav-btn-color:hover {
    background-color: #6987c4;
    color: #fff;
}
.banner-content .price {
    background: linear-gradient(-45deg, #c3996c, #cea87a, #c69c6c, #cfa579, #c39f7b);
    background-size: 400% 400%;
    animation: Gradient 3sease infinite, rocking 3sease infinite;
    animation-delay: 2s;
    padding: 10px 20px;
    color: #fff !important;
    font-weight: 500;
    letter-spacing: 1px;
    border-radius: 29px;
    display: inline-block;
    font-size: 21px;
}
.banner-content h3.ivr-number a {
  background: linear-gradient(-45deg, #c3996c, #cea87a, #c69c6c, #cfa579, #c39f7b);
    background-size: 400% 400%;
    animation: Gradient 3sease infinite, rocking 3sease infinite;
    animation-delay: 2s;
    padding: 10px 20px;
    color: #fff !important;
    font-weight: 500;
    letter-spacing: 1px;
    border-radius: 29px;
    display: inline-block;
    display: block;
    font-size: 22px;
}
.modal .left_col .price {
    font-size: 20px;
    background-color: #caa172;
    padding: 7px 15px;
    width: 100%;
    display: inline-block;
    font-weight: 600;
    color: #ffffff;
}
.form-box.col-lg-5 {
    width: 330px;
    padding: 19px;
    background: #b09677e3;
    outline: 1px solid rgb(0 0 0 / 30%);
    outline-offset: -10px;
    border-radius: 15px;
    background: linear-gradient(-45deg, #c3996c, #cea87a, #c69c6c, #cfa579, #c39f7b);
    /*position: relative;*/
    /*right: 44px;*/
}
.price_list {
    background: #caa172;
}
.main_button {
    margin-top: 20px;
    font-size: 16px;
    font-weight: 600;
    transition: all 0.3sease-in-out;
    cursor: pointer;
    background: linear-gradient(-45deg, #c3996c, #cea87a, #c69c6c, #cfa579, #c39f7b);
    background-size: 400% 400%;
    animation: Gradient 3sease infinite, rocking 3sease infinite;
    animation-delay: 2s;
    padding: 12px 20px;
    color: #000 !important;
    letter-spacing: 1px;
    border-radius: 29px;
    display: inline-block;
}

.section-title span {
    line-height: 0;
    text-transform: capitalize;
    padding-bottom: 5px;
    margin: 0;
    font-size: 16px;
    font-weight: 700;
    color: #caa172;
}
.btn {
    display: inline-block;
    font-weight: 400;
    color: #ffffff;
    text-align: center;
    vertical-align: middle;
    -webkit-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
    user-select: none;
    background-color: transparent;
    border: 1px solid transparent;
    padding: 0.375rem 0.75rem;
    font-size: 1rem;
    line-height: 1.5;
    border-radius: 0.25rem;
    transition: color .15sease-in-out, background-color .15sease-in-out, border-color .15sease-in-out, box-shadow .15sease-in-out;
    border-radius: 100px;
}
.pricingTable10 .heading {
    font-size: 20px;
    color: #caa172;
    letter-spacing: 1px;
    margin-top: 0;
}
.pricingTable10 .price-value {
    display: inline-block;
    position: relative;
    font-size: 44px;
    font-weight: 600;
    color: #caa172;
    transition: all .3sease 0s;
}
.pricingTable10 .pricingTable-header {
    padding: 30px 0;
    background: #b2b2b2;
    position: relative;
    transition: all .3sease 0s;
    border-top-left-radius: 15px;
    border-top-right-radius: 15px;
}
.pricingTable10:hover .pricingTable-header {
    background: #caa172;
}
.phone_element a span {
    font-size: 22px;
    font-weight: 600;
    color: #caa172;
    padding-left: 12px;
}
.floor_plan .image_section {
    text-align: center;
    padding: 18px 18px;
    margin-bottom: 10px;
    background-color: #caa172;
    -webkit-box-shadow: 0 0 15px rgba(0, 0, 0, 0.05);
    box-shadow: 0 0 15px rgba(0, 0, 0, 0.05);
}
.amenities-item h3 {
    margin-bottom: 10px;
    color: #caa172;
    font-size: 24px;
    font-weight: 700;
}
.amenities-item {
    background-color: #2582c417;
    padding: 20px 30px 30px;
    margin-bottom: 30px;
    border-radius: 15px;
    /* min-height: 315px; */
    text-align: center;
}
.floor_plan .wrap h3 {
    color: #FFF;
    margin: 0;
    width: 100%;
    padding: 15PX 20px;
    font-size: 18px;
    background: #caa172;
    font-weight: 600;
    text-align: center;
}
.pricingTable10 .Onwards {
    font-size: 20px;
    letter-spacing: 1px;
    margin-top: 0;
    font-size: 14px;
    display: block;
    text-transform: uppercase;
    letter-spacing: 3px;
    color: #caa172;
    font-weight: 400;
    margin-top: 5px;
}
.contact-form .form-group .form-control {
    height: 39px;
    color: #000000;
    border: 1px solid #ebebeb;
    background-color: #f8f9fb;
    font-size: 14px;
    padding: 11px 20px;
    width: 100%;
}
.form-box input {
    max-width: 100%;
    margin-bottom: 10px;
    padding: 4px 0;
    height: auto;
    background-color: transparent;
    -webkit-box-shadow: none;
    box-shadow: none;
    border-width: 0 0 1px;
    border-style: solid;
    display: block;
    width: 100%;
    line-height: 1.8em;
    font-size: 16px;
    font-weight: 400;
    color: #000;
    background-image: none;
    border-bottom: 1px solid #000;
    border-color: ease-in-out 0.15s, box-shadow ease-in-out 0.15s;
    box-sizing: border-box;
    outline: none;
    list-style: none;
    word-wrap: break-word;
    margin-right: 5px;
}
.modal .btn-close {
    position: absolute;
    color: #fff;
    opacity: 1;
    text-shadow: none;
    font-size: 40px;
    top: 1px;
    right: 7px;
    z-index: 10;
    padding: 0;
    background-color: transparent;
}
div#gallery {
    background-color: #ebf4fa;
}
  .main-nav {
  top: 0;
  left: 0;
  padding: 0;
  height: auto;
  position: fixed;
  z-index: 999;
  width: 100%;
  background-color: #caa172 !important;
  border-bottom: 1px solid #FFFFFF17;
}
.navbar-brand img {
  /* filter: invert(1) brightness(10.5); */
  max-width: 81px!important;
}
.btn {
    background-color: #50906d !important;
    border-radius: 0px !important;
}

    @media only screen and (max-width: 1440px) {
    .home_slider input {
        padding: 0px 0 !important;
    }
}
@media only screen and (max-width: 767px) {
    .form-box.col-lg-5 {
        right: 0%;
        width: 322px!important;
    }
}
@media only screen and (max-width: 767px) {
    .mean-menu {
        background: #caa172;
        display: block;
        height: 100vh;
        left: -100%;
        opacity: 0;
        position: fixed;
        text-align: center;
        top: 0;
        transition: .4sease-in;
        width: 300px;
        z-index: 99999;
                top: 47px !important;
    }
}
@media only screen and (min-width: 1350px) and (max-width: 1699px) {
    p.side-location::before {
        content: "";
        position: absolute;
        top: 20px;
        right: -64%;
        width: 53%;
        height: 1px;
        background-color: #529470;
    }
 
}
@media only screen and (max-width: 744px), (max-width: 1133px) {
  .main-nav nav .navbar-nav .nav-item a {
    text-transform: capitalize;
    color: #fff !important;
    font-weight: 600;
    margin-left: 16px;
    margin-right: 16px;
    font-size: 8px;
    padding: 0;
}
.form-box.col-lg-5 {
    width: auto;
    padding: 19px;
    background: #b09677e3;
    outline: 1px solid rgb(0 0 0 / 30%);
    outline-offset: -10px;
    border-radius: 15px;
    background: linear-gradient(-45deg, #c3996c, #cea87a, #c69c6c, #cfa579, #c39f7b);
    position: relative;
    right: 0px;
}
    p.side-location {
        top: 42%;
        left: -6%;
        font-size: 14px;
    }
}
}
@media only screen and (min-width: 1350px) and (max-width: 1699px) {
    p.side-location::after {
        content: "";
        position: absolute;
        top: 20px;
        left: -65%;
        width: 59%;
        height: 1px;
        background-color: #529470;
    }
}

@media only screen and (max-width: 767px) {
    .mobile_form .form-box.col-lg-5 {
        position: relative;
        padding: 20px 15px;
        width: 89%;
        bottom: 0;
        outline-offset: initial;
        margin: 0 auto;
        position: relative!important;
        right: 7px!important;
    }

  </style>

</head>

<body>


<?php //echo $common_body; ?>
  <div class="home_page" id="home">
 
 <div class="navbar-area">
      <div class="main-nav">
        <div class="container">
          <nav class="navbar navbar-expand-md">
            <a class="navbar-brand" href="index.php">
              <img src="/neww/images/logo-black.png" class="logo-one" alt="Logo">
            </a>
            <div class="mobile-trigger">
              <i></i>
            </div>

            <div class=" navbar-collapse mean-menu">
              <ul class="navbar-nav">
                <li class="nav-item">
                    <a href="/neww/" class="nav-link"> Home </a>
                </li>
                <li class="nav-item">
                  <a href="/neww/#overview" class="nav-link"> Overview </a>
                </li>
                <li class="nav-item">
                  <a href="/neww/#highlight" class="nav-link"> Highlight</a>
                </li>
                <li class="nav-item">
                  <a href="/neww/#pricelist" class="nav-link"> Price List</a>
                </li>
                <li class="nav-item">
                  <a href="/neww/#floorplan" class="nav-link"> Floor Plan</a>
                </li>
                <li class="nav-item">
                  <a href="/neww/#amenities" class="nav-link"> Amenities</a>
                </li>
                <li class="nav-item">
                  <a href="/neww/#location" class="nav-link"> Location</a>
                </li>
                <li class="nav-item">
                  <a href="/neww/#gallery" class="nav-link">Gallery</a>
                </li>
                <li class="nav-item">
                  <a href="/neww/#contactus" class="nav-link"> Contact Us</a>
                </li>
                 <li class="nav-item">
                  <a href="/neww/blog" class="nav-link">Blog</a>
                </li>
                <li>
    <a href="tel:9220639111" class="nav-btn nav-btn-color" style="    border: 1px solid #be8e61;
    background: #be8e61;
    padding: 0 5px 0 5px;
    color: #000;
    margin-top: 11px;">
        +91 9220639111
    </a>
</li>
              </ul>
             
            </div>
          </nav>
        </div>
      </div>
    </div>


    <div id="carouselExampleFade" class="carousel slide carousel-fade home_slider">
      <div class="carousel-inner">
        <div class="carousel-item active">
          <img src="/neww/images/blog-banner.jpg" class="d-block w-100" alt="...">
        </div>
        <div class="carousel-item">
          <img src="/neww/images/blog-banner.jpg" class="d-block w-100" alt="...">
        </div>
        <!-- <div class="carousel-item">
          <img href="/neww/images/banner7.png" class="d-block w-100" alt="...">
        </div> -->
      </div>

      <div class="slider-content col-lg-7 ">
        <div class="banner-content ">
          <!--<p class="mini">BUSINESS & BEYOND </p>-->
         
            <!-- <ul>  
              <li><img href="/neww/images/check-icon.png" class="img-fluid"> Fully Furnished – A First on Dwarka Expressway</li>
          
            </ul> -->
  
            
                
  
          </div>

        <!-- <div class="sticky-patch">
          <img href="/neww/images/gg.png" alt="" class="">
        </div> -->

        <div class="form-box col-lg-5   ">
          <div class="inner">
            <h2>HAVE A QUESTION !</h2>
            <div class="form-row">
              <div class="form-holder">
              <?= $common_form; ?>
              <div class="checkbox-section" style="display: flex; justify-content: space-between; align-items: baseline;">
              <input type="checkbox" name="" value="" checked="">
              <p style="font-size: 10px; color: #000;padding: 10px; margin: 0;line-height: unset; padding-bottom: 0;">I authorise company representatives to Call, SMS, Email, or WhatsApp me about its products and offers. This consent overrides any registration for DNC/NDNC.</p>
            </div>
              </div>
            </div>

          </div>
        </div>
      </div>
      
     
    </div>
    
    
  <div class="container mt-5 mb-5">


  <div class="row">
 <div class="col-md-8">
            <h2 class="blog-title"><?php echo $blog['title'] ?></h2>
            <p class="text-muted">Published on <?php echo date('F j, Y', strtotime($blog['created_date'])); ?></p>
            <img src="<?php echo $blog['thumbnail_img'] ?>" class="img-fluid mb-4" alt="Blog Detail Image">
            <div class="blog-content">
                <p><?php echo $blog['description'] ?></p>
            </div>
        </div>

        <!-- Categories Sidebar -->
      <!-- Categories Sidebar -->
       <div class="col-md-4">
    <h4 class="mb-3">Tags</h4>
    <ul class="category-list">
        <?php foreach ($tags as $index => $blogTag) : ?>
       <li><a href="/neww/tag/<?php print_r($blogTag['blog_tag']['slug']) ?>"><?php print_r($blogTag['blog_tag']['name']) ?></a></li>
              <?php endforeach; ?>

      
    </ul>

    <!-- New Categories Section -->
    <h4 class="mt-4 mb-3">More Categories</h4>
    <ul class="category-list">
        <?php foreach ($category as $index => $blogCategory) : ?>
<li><a href="/neww/category/<?php echo $blogCategory['blog_category']['slug']; ?>"><?php print_r($blogCategory['blog_category']['name']) ?></a></li>

         <?php endforeach; ?>
    </ul>
      <div class="card mb-4">
                    <div class="card-header">Recent Post</div>
                    <div class="card-body">
                        <?php if (!empty($recentBlog)) : ?>
                            <div class="row">
                                <?php foreach ($recentBlog as $blog) : ?>
                                    <div class="col-4" style="margin-bottom:10px">
                                        <a href="blogDetail.php/<?= $blog['slug']; ?>">
                                            <img src="<?= $blog['thumbnail_img']; ?>" class="img-fluid" alt="<?= $blog['title']; ?>">
                                        </a>
                                    </div>
                                    <div class="col-8 d-flex align-items-center">
                                        <a href="/neww/blog/<?= $blog['slug']; ?>" class="text-dark font-weight-bold">
                                                                                     <?= truncateText($blog['title']); ?>
                                        </a>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php else : ?>
                            <p class="text-center">No blogs available.</p>
                        <?php endif; ?>
                    </div>
                </div>
</div>
  </div>
</div>


    <div class="mobile_form">
      <div class="form-box col-lg-5">
        <div class="inner">
          <h2>HAVE A QUESTION</h2>
          <div class="form-row">
            <div class="form-holder">
            <?= $common_form; ?>
            </div>
          </div>

          
          
            </div>
          </div>
        </div>
      </div>
    </div>



  
  
   

    <div class="copy-right-area main_footer">
      <div class="container">
        <div class="copy-right-text text-center">
          <!-- <p><img src="img/qr-towerb.png" style="width: 120px; padding-bottom: 10px;"></p> -->
          <div class="d-flex justify-content-center">
          <!-- <p><img src="img/qrs/qr1.png" style="width: 120px; padding-bottom: 10px;">
          <img src="img/qrs/qr.png" style="width: 120px; padding-bottom: 10px;"></p> -->
            
          </div>
          <p>The Downtown | UPRERAPRJ5805 | https://up-rera.in/projects</p>
          <p>Realty Assistant Pvt. Ltd. RERA: UPRERAAGT18286</p>
          <p class="btm-foot">
              © 2022 Disclaimer This is not the official website of the developer, it belongs to authorised channel partner, and is used for information & marketing purposes only. All rights for logo & images are reserved by the developer. By using or accessing this website you agree with the disclaimer without any qualification or limitation. By accessing this website, the viewer confirms that the information including brochures and marketing collaterals on this website are solely for informational purposes only and the viewer has not relied on this information for making any booking/purchase in any project of the company.
          </p>
          
          </div>
          
          <!--<p style="text-align: center;"><a target="_blank" href="privacy_policy.html" style="    color: #fff;">Disclaimer & Privacy Policy</a>-->
           
            </a>
          </p>
        </div>
      </div>
    </div>


    <div class="mobile-section">
      <!--<a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#exampleModal" class="btn" title="Enquire Now">-->
      <!--  Enquire Now</a>-->
      
      <a href="tel:+91-9220639111" class="btn">Tap To Call</a>
       <a href="https://api.whatsapp.com/send?phone=+919220639111 &text=Hello, " class="btn"> WhatsApp</a> 
    </div>


<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel">
  
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-body">
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        <div class="left_col">
          <div class="background-overlay"></div>
          <div class="content">
            <!--<img href="/neww/images/logo-black.png" alt="project logo" class="img-fluid">-->
            <h3 class="project_name text-white">Sikka The Downtown</h3>
            <h4 class="typo"> Sector 98, Noida</h4>
            <h4 class="typo"> Retail and Office Space</h4>
            <h4 class="price">Starting at ₹38.90 Lakh*</h4>
          </div>
        </div>
        <div class="right_col">
          <div class="animated_form">
            <div class="form-head">
              <!-- <h4 class="form_heading">Send Us A Message!</h4> -->
            </div>
            <div class="form-group">
            <?= $common_form; ?>
            </div>
           

          </div>
        </div>
      </div>
    </div>
  </div>
</div>
   <!--mob-whatsp-icon-->
<a class="whats-app" href="https://api.whatsapp.com/send/?phone=919220646888" target="_blank">
    <img src="/neww/images/wh.png" 
         alt="WhatsApp" style="width: 50px; height: 50px;">
</a>
<style>


    .whats-app {
    position: fixed;
    width: 50px;
    height: 45px;
    bottom: 14px;
    right: 0px;
    /*background-color: #25d366;*/
    color: #FFF;
    border-radius: 50px;
    text-align: center;
    font-size: 30px;
   
    z-index: 100;
}

.my-float {
    margin-top: 16px;
}
@media (max-width: 767px) {
    .whats-app {
    position: fixed;
    width: 50px;
    height: 45px!important;
            bottom: 53px !important;
        right: 5px !important;
    /*background-color: #25d366;*/
    color: #FFF;
    border-radius: 50px;
    text-align: center;
    font-size: 30px;
    
    z-index: 100;
}

.my-float {
    margin-top: 16px;
}

@media only screen and (max-width: 991px) {
       .whats-app {
    position: fixed;
    width: 50px;
    height: 45px!important;
              bottom: 59px;
    right: 7px;
    /*background-color: #25d366;*/
    color: #FFF;
    border-radius: 50px;
    text-align: center;
    font-size: 30px;
    
    z-index: 100;
}

.my-float {
    margin-top: 16px;
}
}


</style>
<!--whatsp-icon-->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css">

  <script href="/neww/js/jquery.min.js"></script>
  <script href="/neww/js/bootstrap.bundle.min.js"></script>
  <script href="/neww/js/jquery.magnific-popup.min.js"></script>
  <script href="/neww/js/custom.js"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>


  <script type="text/javascript" language="javascript">
    var versionUpdate = (new Date()).getTime();
    var script = document.createElement("script");
    script.type = "text/javascript";
    script.src = "https://api2.gtftech.com/scripts/queryform.min.ssl.js?v=" + versionUpdate;
    document.body.appendChild(script);
  </script>

 
  <script>
    $('.without-caption').magnificPopup({
      type: 'image',
      closeOnContentClick: true,
      closeBtnInside: false,
      mainClass: 'mfp-no-margins mfp-with-zoom', // class to remove default margin from left and right side
      image: {
        verticalFit: true
      },
      zoom: {
        enabled: true,
        duration: 300 // don't foget to change the duration also in CSS
      }
    });

    $('.with-caption').magnificPopup({
      type: 'image',
      closeOnContentClick: true,
      closeBtnInside: false,
      mainClass: 'mfp-with-zoom mfp-img-mobile',
      image: {
        verticalFit: true,
        titleSrc: function (item) {
          return item.el.attr('title') + ' · <a class="image-source-link" href="' + item.el.attr('data-source') + '" target="_blank"></a>';
        }
      },
      zoom: {
        enabled: true
      }
    });
  </script>
  <!--------------------- End Here Images Zooming Plugin  ----------------->
  <script>
    $(".moreless-button").click(function () {
      $(".moretext").slideToggle(10);
      if ($(".moreless-button").text() == "Read more") {
        $(this).text("Read less");
      } else {
        $(this).text("Read more");
      }
    });

    $(".nav-link").click(function(){
      $("body").removeClass("mobile-open")
    });
 
    $(document).ready(function(){
      setTimeout(function(){
        $('#exampleModal').modal('show')
      },5000)
    })
  </script>
    <script>
      $(document).ready(function() {
         $(".btn-close").click(function() {
            $(".leadFormServer").each(function() {
               this.reset();
            });
            $(".common_form_main").each(function() {
               this.reset();
            });
         })
         $('.phonevaidation').on('input', function(e) {
            var nameValidationCheck = $(this).val();
            console.log(nameValidationCheck);

            if (nameValidationCheck && nameValidationCheck.length === 10) {
                            $(this).css('border', ''); // Apply red border for invalid input
            } else {
  $(this).css('border', '2px solid red'); // Apply green border for valid input

            }
         });
         $('.backupForm').on('submit', function(e) {
            e.preventDefault();
            elemObj = this;
            checkFalse = false;
            var nameValidationCheck = $(this).closest('form').find('.namevaidation').val();
            var phoneValidationCheck = $(this).closest('form').find('.phonevaidation').val();
            var emailValidationCheck = $(this).closest('form').find('.emailVaidation').val();

            // var checkPhoneLength = $(this).closest('form').find('.phonevaidation').val().length;
            //   alert(checkPhoneLength.length);

            if (!nameValidationCheck) {
               checkFalse = true;
               $(this).closest('form').find('.namevaidation').attr({
                  'style': "border:red solid 1px!important"
               });
            }
            if (!phoneValidationCheck) {
               checkFalse = true;
               $(this).closest('form').find('.phonevaidation').attr({
                  'style': "border:red solid 1px!important"
               });
            }
            if (phoneValidationCheck.length != 10) {
               checkFalse = true;
               $(this).closest('form').find('.phonevaidation').attr({
                  'style': "border:red solid 1px!important"
               });
            }

            if (emailValidationCheck) {
               var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;

               if (emailReg.test(emailValidationCheck) == true || emailReg.test(emailValidationCheck) == 1) {
                  retVal = 1
               } else {
                  checkFalse = true;
                  $(this).closest('form').find('.emailVaidation').attr({
                     'style': "border:red solid 1px!important"
                  });
               }

            }
            if (!checkFalse) {

               $.ajax({
                  url: 'send.php',
                  type: 'POST',
                  data: $(this).serialize(),
                  success: function(response) {
                     console.log(response); // Handle the response data
                     $('.backupForm').each(function() {
                        this.reset();
                     }); // Reset the form
                     // Display success message
                     
                     window.location.href = 'abc.com/thank-you.php/'
                  },
                  error: function(xhr, status, error) {
                     console.error('Error:', error);
                     alert('There was an error submitting the form.'); // Display error message
                  }
               });
            }
         });
      });
   </script>
  </div><script type="text/javascript" href="/neww/js/queryform.min.ssl.js"></script>
  
  <?= $common_footer; ?> 
</body>
</html>