
<!DOCTYPE html>
<html lang="en">

<head>


	<style>
		body {
			font-family: sans-serif;
		}

		section {
			width: 100%;
			display: inline-block;
			position: relative;
			margin-bottom: 50px;
		}

		.ban-cont-over {
			background: rgba(0, 0, 0, 0.0);
			padding: 30px 0 60px;
		}

		.cont-thank {
			text-align: center;
			background: rgba(255, 255, 255, 0.8);
			max-width: 600px;
			margin: 32px auto;
			padding: 50px 35px;
			outline: 1px solid #f6f6f6;
			border-radius: 16px;
		}

		.cont-thank h1 {
			font-size: 38px;
			font-weight: 600;
			color: #750333;
		}

		.cont-thank h3 {
			text-transform: unset;
			font-size: 16px;
			line-height: 28px;
			font-weight: 600;
			color: #222;
			max-width: 540px;
			margin: 0 auto 26px;
		}

		.helping {
			margin-bottom: 29px;
		}

		.helping h4 {
			text-transform: unset;
			margin-bottom: 10px;
			font-size: 18px;
			line-height: 31px;
			font-weight: 600;
		}

		.btn-phone {
			background-color: #01463b;
			border-color: #01463b;
			color: #fff;
		}

		.custbtn {
			display: inline-block;
			border: 2px solid;
			padding: 12px 52px;
			margin-top: 3px;
			border-radius: 5px;
			font-size: 16px;
			line-height: 10px;
			font-weight: 500;
		}

		.help-item img {
			width: 19px;
		}

		a {
			text-decoration: none;
			color: inherit;
		}

		@media (max-width: 640px) {
			.ban-cont-over {
				background: rgba(0, 0, 0, 0.1);
			}

			.cont-thank {
				padding: 20px 10px;
			}

			.cont-thank h1 {
				font-size: 20px;
			}

			.cont-thank h3 {
				margin-bottom: 20px;
				font-size: 15px;
				line-height: 22px;
			}

			.helping h4 {
				font-size: 16px;
			}

			.custbtn {
				font-size: 14px;
				line-height: 16px;
				padding: 10px 20px;
				font-weight: 600;
				margin-left: 25px;
			}
		}

		@media (max-width: 768px) {
			.ban-cont-over {
				padding: 10px 10px 70px;
			}
		}

		@media only screen and (max-width: 992px) {
			.container {
				padding: 0 10px;
				box-sizing: border-box;
			}
		}
	</style>
</head>

<body>

	<section class="banner-content mb-0">
		<div class="ban-cont-over">
			<div class="container">
				<div class="cont-thank">
					<h1>Thank you</h1>
					<h3>for being Interested in the Property. Our Customer Relationship Manager will get back to you shortly</h3>
					<div class="helping">
						<h4>FOR IMMEDIATE ASSISTANCE</h4>
						<div class="help-item">
							<a href="tel:+919220639111" class="custbtn btn-phone">
								<img src="https://leads.realtyassistant.in/public/phone.webp" alt="phone icon">
								<span>+91 92-2063-9111 </span>
							</a>
						</div>
					</div>
					<div class="back_link">
						<h3><a href="https://propertiesgurugram.in/neww/" id="indexUrlLink"><i class="fa fa-undo" aria-hidden="true"></i> BACK TO HOMEPAGE</a></h3>
					</div>
				</div>
			</div>
		</div>
	</section>
</body>
<script>
    document.addEventListener('DOMContentLoaded', function() {
    // Function to get query parameters from URL
    function getQueryParams() {
        let params = {};
        window.location.search.substring(1).split('&').forEach(function(param) {
            let parts = param.split('=');
            params[decodeURIComponent(parts[0])] = decodeURIComponent(parts[1]);
        });
        return params;
    }

    // Get leadId from query parameters
    let params = getQueryParams();
    if (params['leadId']) {
        console.log(params['leadId']); // Equivalent to PHP's print($leadId);

        // Create the data object
        let formData = new URLSearchParams();
        formData.append('lead_id', params['leadId']);

        // Make the POST request
        fetch('https://leads.realtyassistant.in/api/common-thankyou', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            console.log(data); // Handle the response data as needed
        })
        .catch(error => {
            console.error('Error:', error);
        });
    }
});</script>


</html>